<?php
if (isset($_POST['submit'])) {
    // Connect to MySQL database
    $conn = new mysqli('localhost', 'root', '', 'your_database');

    // Check if the connection was successful
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Get the uploaded file information
    $imageName = $_FILES['profilePic']['name'];
    $imageTmpName = $_FILES['profilePic']['tmp_name'];
    $imageSize = $_FILES['profilePic']['size'];
    $imageError = $_FILES['profilePic']['error'];
    $imageType = $_FILES['profilePic']['type'];

    // Check if the image file was uploaded without errors
    if ($imageError === 0) {
        // Validate file size and type (optional)
        if ($imageSize < 1000000) { // 1MB limit
            // Get file extension
            $imageExtension = pathinfo($imageName, PATHINFO_EXTENSION);
            $imageExtension = strtolower($imageExtension);

            // Check allowed file types (image files)
            $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];
            if (in_array($imageExtension, $allowedTypes)) {
                // Create a unique file name to avoid overwriting
                $imageNewName = uniqid('', true) . '.' . $imageExtension;

                // Set the upload directory path
                $uploadDir = 'uploads/';
                $uploadFilePath = $uploadDir . $imageNewName;

                // Move the uploaded file to the target directory
                if (move_uploaded_file($imageTmpName, $uploadFilePath)) {
                    // Save the file path into the database (assuming you have a user table)
                    $userId = 1; // Use the logged-in user's ID or session variable here
                    $sql = "UPDATE users SET profile_pic = ? WHERE id = ?";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("si", $uploadFilePath, $userId); // 'si' = string, integer
                    $stmt->execute();

                    // Success message
                    echo "Profile picture uploaded and saved successfully!";
                } else {
                    echo "There was an error uploading the file.";
                }
            } else {
                echo "Invalid file type. Only JPG, JPEG, PNG, and GIF are allowed.";
            }
        } else {
            echo "File size is too large. Maximum allowed size is 1MB.";
        }
    } else {
        echo "Error uploading the image.";
    }

    // Close the database connection
    $conn->close();
}
?>
