<?php
session_start();
include "db_connection.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_POST['user_id'];
    $phone = $_POST['phone'];
    $department = $_POST['department'];
    $position = $_POST['position'];

    // Check if profile already exists
    $check = $conn->prepare("SELECT * FROM profiles WHERE user_id = ?");
    $check->bind_param("i", $user_id);
    $check->execute();
    $exists = $check->get_result()->fetch_assoc();

    if ($exists) {
        $stmt = $conn->prepare("UPDATE profiles SET phone = ?, department = ?, position = ? WHERE user_id = ?");
        $stmt->bind_param("sssi", $phone, $department, $position, $user_id);
    } else {
        $stmt = $conn->prepare("INSERT INTO profiles (user_id, phone, department, position) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("isss", $user_id, $phone, $department, $position);
    }

    $stmt->execute();

    // Update session
    $_SESSION['department'] = $department;
    $_SESSION['position'] = $position;

    // Redirect to refresh and show new values
    header("Location: profile.php");
    exit();
}
?>
