<?php
include "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];
    $phone = $_POST['phone'];
    $department = $_POST['department'];
    $position = $_POST['position'];

    // Check if profile exists
    $query_check = "SELECT * FROM profiles WHERE user_id = ?";
    $stmt_check = $conn->prepare($query_check);
    $stmt_check->bind_param("i", $user_id);
    $stmt_check->execute();
    $result = $stmt_check->get_result();

    if ($result->num_rows > 0) {
        // Update profile if it exists
        $query_update = "UPDATE profiles SET phone = ?, department = ?, position = ? WHERE user_id = ?";
        $stmt_update = $conn->prepare($query_update);
        $stmt_update->bind_param("sssi", $phone, $department, $position, $user_id);
        $stmt_update->execute();
        echo "Profile updated successfully!";
    } else {
        // Insert new profile if none exists
        $query_insert = "INSERT INTO profiles (user_id, phone, department, position) VALUES (?, ?, ?, ?)";
        $stmt_insert = $conn->prepare($query_insert);
        $stmt_insert->bind_param("isss", $user_id, $phone, $department, $position);
        $stmt_insert->execute();
        echo "Profile created successfully!";
    }
}
?>
