<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Interactive Table Display</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .header {
    position: fixed;
    top: 0;
    left: 300px;
    width: calc(100% - 300px);
    height: 80px; /* Increased height */
    padding: 20px 25px; /* Increased padding */
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #c5cbce; /* Thicker border for impact */
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
}

/* Diagonal Line Overlay for Header */
.header::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px; /* Match sidebar effect */
    opacity: 0.3;
    pointer-events: none; /* Ensures it doesn't block clicks */
    z-index: -1; /* Keeps it behind the header content */
}

body {
    display: flex;
    height: 100vh;
    background: #e1e5e6; /* A solid color */
    color: #3B2F2F; /* Darker warm brown for text */
}

.sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 74px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 40px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 9px 8px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}

        .dropbtn {
            background: #f6f9fa;
            color: black;
            padding: 10px 15px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            margin-right: 40px;
            box-shadow: 0px 4px 10px rgba(1, 1, 1, 1);
        }

        .dropdown {
            position: relative;
            display: inline-block;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            background: white;
            min-width: 50px;
            box-shadow: 0px 4px 10px rgba(1, 1, 1, 1);
            border-radius: 5px;
            z-index: 1;
        }

        .dropdown-content a {
            display: block;
            color: #344648;
            padding: 10px;
            text-decoration: none;
            transition: 0.3s;
        }

        .dropdown-content a:hover {
            background: #F7B9A1;
            color: white;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content a img {
            display: block;
            margin: auto;
            transition: transform 0.2s;
        }

        .dropdown-content a:hover img {
            transform: scale(1.1);
        }

        .main-content {
            flex: 1;
            padding: 100px 50px;
            text-align: center;
        }

        .content {
            display: none;
        }

        .active {
            display: block;
        }

        .chart-container {
            width: 60%;
            margin: 20px auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: left;
        }

        th {
            background: #F7B9A1;
            color: white;
        }

        tr:nth-child(even) {
            background: #f9f9f9;
        }

        .card-container {
    display: flex;
    justify-content: center;
    gap: 20px;
    margin-top: 40px;
}

.booking-card {
    width: 200px;
    padding: 15px;
    border-radius: 10px;
    text-align: center;
    background-color: #f8f9fa;
    box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
    font-size: 18px;
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
}

/* Hover Effect */
.booking-card:hover {
    transform: translateY(-5px);
    box-shadow: 0px 6px 10px rgba(0, 0, 0, 0.15);
}

.booking-card h2 {
    margin: 0;
    font-size: 22px;
    color: #333;
}

/* Booking Status Styling */
.booking-card .status {
    font-size: 20px;
    font-weight: bold;
}

.booked {
    color: green;
}

.available {
    color: red;
}

table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ccc;
            text-align: center;
        }
        th {
            background: #344648;
            color: white;
        }

        .logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&family=Montserrat:wght@700&family=Bangers&family=Fredoka:wght@700&family=Lobster&display=swap');
.logo-badge span {
    color: #0a0a0a;
}
        #current-date {
            font-family: 'Montserrat', sans-serif;
    font-size: 34px;
    font-weight: 800;
    letter-spacing: 2px;
    margin-left: 280px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50;
    text-shadow:
        2px 2px 0 #2C3E50,
        4px 4px 0 #1A252F,
        6px 6px 0 #0F151B;
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
        }

        @keyframes fadeIn {
            to {
                opacity: 1;
                transform: none;
            }
        }
/* Bar Chart Styling */
#exitChart {
    max-width: 500px;
    width: 200%;
    height: auto;
    
    /* Center alignment with margin */
    margin: 20px auto 20px 520px;

    /* Glassmorphism Effect */
    background: rgba(32, 76, 126, 0.1);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);

    /* Rounded Corners */
    border-radius: 12px;
    border: 2px solid rgba(2, 1, 1, 0.2);

    /* Soft shadow */
    box-shadow: 0px 5px 15px rgba(25, 60, 107, 0.2);
}

/* Ensure parent container allows proper placement */
.chart-container {
    display: flex;
    justify-content: flex-start; /* Aligns it with margin-left */
    align-items: center;
    width: 100%;
}

/* Table Styling */
#staff-exit-table {
    width: 100%;
    max-width: 1000px;
    margin: 40px auto 20px 280px;
    border-collapse: collapse;
    background: rgba(0, 0, 0, 0.6); /* Slight transparency */
    border-radius: 12px;
    overflow: hidden;
    
    /* Stronger, deeper shadow effect */
    box-shadow: 
        10px 10px 30px rgba(0, 0, 0, 0.7), /* Outer deep shadow */
        -5px -5px 15px rgba(255, 255, 255, 0.1), /* Top light glow */
        inset 0px 5px 10px rgba(255, 255, 255, 0.1); /* Inner shadow */

    text-align: center;
    backdrop-filter: blur(12px); /* More blur for stronger glass effect */
    -webkit-backdrop-filter: blur(12px);
    border: 1px solid rgba(255, 255, 255, 0.2); /* Light border for contrast */
}
/* Table Headers */
#staff-exit-table thead tr {
    background: linear-gradient(135deg, rgba(1, 1, 1, 1), rgba(1, 1, 1, 1));
    color: white;
}

/* Table Cells */
#staff-exit-table th, 
#staff-exit-table td {
    padding: 12px;
    border: 1px solid rgba(255, 255, 255, 0.2); /* Subtle border */
}

/* Alternate Row Colors */
#staff-exit-table tbody tr:nth-child(even) {
    background: rgba(255, 255, 255, 0.2);
}

#staff-exit-table tbody tr:nth-child(odd) {
    background: rgba(255, 255, 255, 0.1);
}

/* Hover Effect on Rows */
#staff-exit-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.3);
    transition: 0.3s;
}

/* 🌟 Flexbox Container for Availability Cards */
.availability-container {
    display: flex;
    justify-content: space-between; /* Push first card left, second card right */
    gap: 20px;
    margin: 120px 250px 20px 100px; /* Increased top margin from 40px to 60px */
    flex-wrap: wrap; /* Ensures responsiveness */
    width: 100%; /* Make sure it spans the full width */
}


/* 🏷️ Availability Card */
.availability-card {
    width: 200px;
    padding: 30px;
    border-radius: 12px;
    text-align: center;

    /* 🎨 Glassmorphism Effect */
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    
    /* 🖌️ Border & Shadow */
    border: 2px solid rgba(255, 255, 255, 0.2);
    box-shadow: 5px 5px 15px rgba(1, 1, 1, 1);
    color: white;
    font-size: 1.1em;
}

/* 🔹 Status Styling */
.availability-card span {
    display: block;
    font-weight: bold;
    font-size: 1.2em;
    margin-top: 10px;
    color: cyan;
}

/* 🏷️ H2 Styling Below Cards */
.availability-container + h2 {
    margin-left: 150px; /* Adjusted margin-left to match the new card position */
    font-size: 1.8em;
    color: white;
    text-align: center;
    margin-bottom: 20px;
}

/* 📊 Meeting Room Table Styling */
#meeting-room-table {
    margin-right: -120px; /* Adjusted margin-left to move the table closer to the left */
    margin-top: 20px;
    width: 270%;
    max-width: 1000px;
    border-collapse: collapse;
    border-radius: 12px;
    overflow: hidden;
    text-align: center;

    /* 🎨 Glassmorphism Effect */
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);
    box-shadow: 0px 5px 15px rgba(255, 255, 255, 0.2);

    text-align: center;
    backdrop-filter: blur(12px); /* More blur for stronger glass effect */
    -webkit-backdrop-filter: blur(12px);
    border: 1px solid rgba(255, 255, 255, 0.2); /* Light border for contrast */
}

/* 🎨 Table Header */
#meeting-room-table thead {
    background: rgba(255, 255, 255, 0.3);
    color: white;
}

/* Table Header and Cells */
#meeting-room-table th, #meeting-room-table td {
    padding: 12px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    color: white;
}

/* 🎭 Alternating Row Colors */
#meeting-room-table tbody tr:nth-child(even) {
    background: rgba(255, 255, 255, 0.05);
}

/* 🏆 Hover Effect */
#meeting-room-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.15);
    transition: 0.3s;
}

/* 🚨 Ensure Other Tables Are Not Affected */
table:not(#meeting-room-table) {
    background: none !important;
    box-shadow: none !important;
    backdrop-filter: none !important;
    -webkit-backdrop-filter: none !important;
}


/* 📌 Main Section to Organize Layout */
.car-section {
    display: flex;
    flex-direction: column; /* Stack items */
    align-items: center; /* Center align items */
    width: 100%;
}

/* 📌 Flexbox Container for Car Cards */
.car-container {
    display: flex;
    justify-content: flex-start; /* Align cards to left */
    gap: 20px; /* Space between cards */
    margin: 20px auto;
    flex-wrap: wrap; /* Allows wrapping on smaller screens */
    margin-right: 300px; /* Shift entire card section to right */
}

/* 🚗 Car Cards */
.car-card {
    margin-top: 100px;
    margin-right: -800px;
    width: 350px;
    padding: 40px;
    border-radius: 12px;
    text-align: center;
    font-weight: bold;
    color: white;
    transition: 0.3s;

    /* 🎨 Glassmorphism */
    background: rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
    -webkit-backdrop-filter: blur(10px);

    /* 🖌️ Border & Shadow */
    border: 2px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0px 5px 15px rgba(255, 255, 255, 0.2);
}

/* ✅ Available Car (Greenish) */
.available {
    background: rgba(68, 158, 180, 0.986);
    color: black;
}

/* ❌ Booked Car (Darkened) */
.booked {
    background: rgba(0, 0, 0, 0.7);
    color: white;
}

/* 📌 Company Car Table Styling */
#company-car-table {
    width: 100%;
    max-width: 1000px;
    margin: 40px auto 20px -200px;
    border-collapse: collapse;
    background: rgba(0, 0, 0, 0.6); /* Slight transparency */
    border-radius: 12px;
    overflow: hidden;
    
    /* Stronger, deeper shadow effect */
    box-shadow: 
        10px 10px 30px rgba(0, 0, 0, 0.7), /* Outer deep shadow */
        -5px -5px 15px rgba(255, 255, 255, 0.1), /* Top light glow */
        inset 0px 5px 10px rgba(255, 255, 255, 0.1); /* Inner shadow */

    text-align: center;
    backdrop-filter: blur(12px); /* More blur for stronger glass effect */
    -webkit-backdrop-filter: blur(12px);
    border: 1px solid rgba(255, 255, 255, 0.2); /* Light border for contrast */
}

/* 🏷️ Table Header */
#company-car-table thead {
    background: rgba(255, 255, 255, 0.2);
    font-weight: bold;
    color: cyan;
}

/* 📊 Table Rows */
#company-car-table tbody tr {
    transition: 0.3s;
}

/* 🔹 Table Cells */
#company-car-table th, #company-car-table td {
    padding: 12px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.2);
}

/* 🌟 Hover Effect */
#company-car-table tbody tr:hover {
    background: rgba(255, 255, 255, 0.2);
    transition: 0.3s;
}
/* Apply styling only inside #content1 */
#content1 .staff-exit-title {
    display: flex;
    justify-content: flex-end; /* Aligns to the right */
    margin: 40px 50px 10px 0px; /* Adjust only this section */
}

#content1 .staff-exit-title h2 {
    letter-spacing: 5px;
    font-size: 25px;
    font-weight: 800;
    text-transform: uppercase;
    color: white;
    padding: 10px 20px;
    border-radius: 8px;
    box-shadow: 2px 2px 10px rgba(1, 1, 1, 1);
}
#content2 .meeting-room-title {
    display: flex;
    justify-content: flex-end; /* Aligns to the right */
    margin: 80px 70px 0px 0px; /* Adjust margin as needed */
}

#content2 .meeting-room-title h2 {
    letter-spacing: 5px;
    font-size: 25px;
    font-weight: 800;
    text-transform: uppercase;
    color: white;
    padding: 10px 20px;
    border-radius: 8px;
    box-shadow: 2px 2px 10px rgba(1, 1, 1, 1);
}

    </style>

<style>
    .user-info { margin-top: 60px; font-size: 18px; }
    ul { list-style-type: none; padding: 0; }
    ul li { margin: 10px 0; }
    ul li a { text-decoration: none; color: white; }
</style>
</head>
<body>
    <div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>
        <div style="
    margin-top: 80px; 
    font-size: 14px; 
    color: white; 
    border: 2px solid white; 
    padding: 15px 20px; 
    border-radius: 8px; 
    box-shadow: 0 2px 8px rgba(1,1,1,1); 
    width: fit-content;
    font-family: 'Arial', sans-serif; 
    font-weight: bold; 
    text-transform: uppercase; 
    text-align: justify-end;
">
    <div><span style="color: #D9A679;">Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
</div>


        <ul>
        <li><a href="profile.php" style="text-decoration: none; color: white;">IdentiKey</a></li>
            <li><a href="test.php" style="text-decoration: none; color: white;">HubView</a></li>
            <li><a href="service.php" style="text-decoration: none; color: white;">SyncPlanner</a></li>
            <li><a href="StepOut.html" style="text-decoration: none; color: white;">QuickForm</a></li>
            <li><a href="event.php" style="text-decoration: none; color: white;">EventMate</a></li>   
            <li><a href="dashboard.html" style="text-decoration: none; color: white;">DashLytics</a></li>   
            <li><a href="history.php" style="text-decoration: none; color: white;">TrackBack</a></li>  
        </ul> 
    </div>

    <div class="header">
        <div id="current-date" class="date-display"></div>
        <div class="dropdown">
            <!-- Add Font Awesome in <head> -->
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
            <!-- Button with Icon -->
            <button class="dropbtn"><i class="fa-solid fa-chevron-down"></i></button>
            <div class="dropdown-content">
                <a href="#" onclick="showContent('content1')">StepOut</a>
                <a href="#" onclick="showContent('content2')">MeetRoom</a>
                <a href="#" onclick="showContent('content3')"> CarDrive</a>
            </div>             
        </div>
    </div>

    <div class="main-content">
        <div id="content1" class="content active">
            <div class="content-wrapper">
                <canvas id="exitChart"></canvas>
    
                <div class="staff-exit-title">
                    <h2>StepOut'S Data</h2>
                </div>
    
                <table id="staff-exit-table" border="1">
                    <thead>
                        <tr>
                            <th>Time</th>
                            <th>Name</th>
                            <th>Reason</th>
                            <th>Location</th>
                            <th>Return Time / Action</th> <!-- NEW COLUMN -->
                        </tr>
                    </thead>
                    <tbody id="staff-exit-list"></tbody>
                </table>
            </div>
        </div>
    </div>    
    
        <div id="content2" class="content">
        
        <div class="availability-container">
            <div class="availability-card">
                <p>MORNING</p>
                <span id="am-status">Checking...</span>
            </div>
            <div class="availability-card">
                <p>EVENING</p>
                <span id="pm-status">Checking...</span>
            </div>
        </div>

        <div class="meeting-room-title">
        <h2>MeetRoom'S Data</h2>
        </div>

        <table id="meeting-room-table">
            <thead>
                <tr>
                    <th>Time</th>
                    <th>Name</th>
                    <th>Reason</th>
                </tr>
            </thead>
            <tbody id="meeting-room-list"></tbody>
        </table>   
        </div>                  
    
        <div id="content3" class="content">
        <div class="car-section">
            <!-- Car Cards -->
            <div class="car-container">
                <div id="xtrail-card" class="car-card">
                    <h2>Nissan X-Trail</h2>
                    <p id="xtrail-status">Available</p>
                </div>
                <div id="fortuner-card" class="car-card">
                    <h2>Toyota Fortuner</h2>
                    <p id="fortuner-status">Available</p>
                </div>
            </div>
        
            <!-- Reservation Table (Centered Below) -->
            <table id="company-car-table">
                <thead>
                    <tr>
                        <th>Pickup Time</th>
                        <th>Name</th>
                        <th>Car Model</th>
                    </tr>
                </thead>
                <tbody id="company-car-list"></tbody>
            </table>
        </div>
           
        </div>   
        </div>  
    
    <style>
        .content {
            display: none;
        }
        .content.active {
            display: block;
        }
    </style>

    <script>
    const loggedInName = "<?php echo $_SESSION['short_name']; ?>";
</script>


<script>
    function formatDate() {
        const today = new Date();
        const options = { day: '2-digit', month: 'long', year: 'numeric' };
        const dateStr = today.toLocaleDateString('en-GB', options).toUpperCase();
        const dayStr = today.toLocaleDateString('en-GB', { weekday: 'long' }).toUpperCase();
        
        document.getElementById('current-date').innerHTML = `${dateStr} (${dayStr})`;
    }

    formatDate();
</script>

    <script>
        function showContent(contentId) {
            document.querySelectorAll(".content").forEach(content => {
                content.classList.remove("active");
            });
            document.getElementById(contentId).classList.add("active");
        }
    
        function fetchStaffExitEvents() {
    let today = new Date().toISOString().split('T')[0];

    fetch(`get_event.php?date=${today}&type=staff_exit`)
        .then(response => response.json())
        .then(data => {
            let exitList = document.getElementById("staff-exit-list");

            exitList.innerHTML = data.staff_exit.length 
    ? data.staff_exit.map(event => `
        <tr>
            <td>${event.time}</td>
            <td>${event.name}</td>
            <td>${event.reason}</td>
            <td>${event.location}</td>
            <td>
                ${
                    !event.return_time && event.name === loggedInName
                    ? `<button onclick="stopExitById(${event.id}, this)">Return</button>`
                    : event.return_time 
                        ? `${event.return_time} <span style="color: green;">(At Office Now)</span>`
                        : ''
                }
            </td>
        </tr>`
    ).join('')
    : "<tr><td colspan='5'>No staff exits today.</td></tr>";

    

            // Process Data for Chart
            let reasonCounts = {};
            data.staff_exit.forEach(event => {
                reasonCounts[event.reason] = (reasonCounts[event.reason] || 0) + 1;
            });

            // Prepare Chart Data
            let labels = Object.keys(reasonCounts);
            let values = Object.values(reasonCounts);

            // Draw Chart
            drawExitChart(labels, values);
        });
}

function drawExitChart(labels, values) {
    let ctx = document.getElementById("exitChart").getContext("2d");

    // Destroy previous chart instance if it exists
    if (window.exitChartInstance) {
        window.exitChartInstance.destroy();
    }

    window.exitChartInstance = new Chart(ctx, {
        type: "bar",
        data: {
            labels: labels,
            datasets: [{
                label: "StepOut Reasons",
                data: values,
                backgroundColor: "rgba(75, 192, 192, 0.6)",
                borderColor: "rgba(1, 1, 1, 1)",
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                x: {
                    title: {
                        display: true,
                        text: "Reason" // X-axis title
                    }
                },
                y: {
                    title: {
                        display: true,
                        text: "Total Staff" // Y-axis title
                    },
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1 // Ensures Y-axis increases by 1
                    }
                }
            }
        }
    });
}
function stopExitById(id, buttonElement) {
    if (!confirm("Mark yourself as returned to the office?")) return;

    fetch("stop_exit.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ id: id })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            buttonElement.parentElement.innerHTML = `${data.return_time} <span style="color: green;">(At Office Now)</span>`;
        } else {
            alert(data.message || "Error updating return time.");
        }
    })
    .catch(error => console.error("Error:", error));
}

function fetchMeetingRoomBookings() {
    let today = new Date().toISOString().split('T')[0];
    
    fetch(`get_event.php?date=${today}&type=meeting_room`)
        .then(response => response.json())
        .then(data => {
            let meetingList = document.getElementById("meeting-room-list");
            let amStatus = document.getElementById("am-status");
            let pmStatus = document.getElementById("pm-status");

            if (!data.meeting_room.length) {
                meetingList.innerHTML = "<tr><td colspan='3'>No bookings today.</td></tr>";
                amStatus.innerText = "Available";
                pmStatus.innerText = "Available";
                amStatus.style.color = "green";
                pmStatus.style.color = "green";
                return;
            }

            let amBooked = false, pmBooked = false;

            meetingList.innerHTML = data.meeting_room.map(event => {
                let eventHour = parseInt(event.time.split(':')[0]); // Extract hour from "HH:MM:SS"
                
                if (eventHour >= 8 && eventHour < 12) amBooked = true;  // 8 AM - 11:59 AM
                if (eventHour >= 12 && eventHour <= 17) pmBooked = true; // 12 PM - 5 PM

                return `
                    <tr>
                        <td>${event.time}</td>
                        <td>${event.name}</td>
                        <td>${event.reason}</td>
                    </tr>`;
            }).join('');

            // Update availability status
            amStatus.innerText = amBooked ? "Not Available" : "Available";
            pmStatus.innerText = pmBooked ? "Not Available" : "Available";

            amStatus.style.color = amBooked ? "red" : "green";
            pmStatus.style.color = pmBooked ? "red" : "green";
        })
        .catch(error => console.error("Error fetching data:", error));
}
    
function fetchCompanyCarEvents() {
    let today = new Date().toISOString().split('T')[0];

    fetch(`get_event.php?date=${today}&type=company_car`)
        .then(response => response.json())
        .then(data => {
            let carList = document.getElementById("company-car-list");
            let xtrailCard = document.getElementById("xtrail-card");
            let fortunerCard = document.getElementById("fortuner-card");
            let xtrailStatus = document.getElementById("xtrail-status");
            let fortunerStatus = document.getElementById("fortuner-status");

            // Reset UI (assume both available initially)
            xtrailCard.classList.remove("booked");
            xtrailCard.classList.add("available");
            xtrailStatus.innerText = "Available";

            fortunerCard.classList.remove("booked");
            fortunerCard.classList.add("available");
            fortunerStatus.innerText = "Available";

            // Populate Table
            carList.innerHTML = data.company_car.length ? data.company_car.map(event => `
                <tr>
                    <td>${event.pickup_time}</td>
                    <td>${event.name}</td>
                    <td>${event.car_model}</td>
                </tr>`).join('') : "<tr><td colspan='3'>No car reservations today.</td></tr>";

            // Loop through bookings and mark as booked
            data.company_car.forEach(event => {
                if (event.car_model.toLowerCase().includes("x-trail")) {
                    xtrailCard.classList.remove("available");
                    xtrailCard.classList.add("booked");
                    xtrailStatus.innerText = `Booked by ${event.name}`;
                }
                if (event.car_model.toLowerCase().includes("fortuner")) {
                    fortunerCard.classList.remove("available");
                    fortunerCard.classList.add("booked");
                    fortunerStatus.innerText = `Booked by ${event.name}`;
                }
                
            });
        });
}
    
        document.addEventListener("DOMContentLoaded", () => {
            fetchStaffExitEvents();
            fetchMeetingRoomBookings();
            fetchCompanyCarEvents();
        });
    </script>
    
    <nav>
        <button onclick="showContent('content1')">Staff Exit</button>
        <button onclick="showContent('content2')">Meeting Room</button>
        <button onclick="showContent('content3')">Company Car</button>
    </nav>
    

<style>
    
    .close {
        cursor: pointer;
        float: right;
        font-size: 24px;
    }
</style>
    
</body>
</html>
