<?php
include 'db_connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["form_type"])) {
        $form_type = $_POST["form_type"];

        if ($form_type == "staff_exit") {
            $sql = "INSERT INTO staff_exit (name, date, time, reason) VALUES (?, ?, ?, ?)";
        } elseif ($form_type == "meeting_room") {
            $sql = "INSERT INTO meeting_room (name, date, time, reason) VALUES (?, ?, ?, ?)";
        } elseif ($form_type == "company_car") {
            $sql = "INSERT INTO company_car (name, date, car_model, pickup_time) VALUES (?, ?, ?, ?)";
        } else {
            die("Invalid form type.");
        }

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $_POST["name"], $_POST["date"], $_POST["time"], $_POST["reason"]);
        $stmt->execute();
        $stmt->close();
        $conn->close();

        echo "Form submitted successfully.";
    } else {
        echo "No form type specified.";
    }
} else {
    echo "Invalid request.";
}
?>
