<?php
session_start();
include 'db_connection.php'; // connect to DB

$data = json_decode(file_get_contents("php://input"));

if (!isset($_SESSION['short_name'])) {
    echo json_encode(["success" => false, "message" => "Not logged in"]);
    exit;
}

$staff_name = $_SESSION['short_name'];
$id = $data->id;

// Only update if the row belongs to this logged-in user
$query = "UPDATE staff_exit SET return_time = NOW() WHERE id = ? AND name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("is", $id, $staff_name);

if ($stmt->execute() && $stmt->affected_rows > 0) {
    echo json_encode(["success" => true, "return_time" => date("H:i")]);
} else {
    echo json_encode(["success" => false, "message" => "Cannot update return time."]);
}
?>
