<?php
// Connect to database
include 'db_connection.php'; // Make sure this file contains the correct database connection

$month = $_GET['month'] ?? date('Y-m'); // Default to the current month if not provided

$sql = "SELECT time, name, reason, location FROM staff_exit WHERE DATE_FORMAT(date, '%Y-%m') = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $month);
$stmt->execute();
$result = $stmt->get_result();

$staff_exit = [];
while ($row = $result->fetch_assoc()) {
    $staff_exit[] = $row;
}

echo json_encode(["staff_exit" => $staff_exit]);

$conn->close();
?>
