<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Service - Yearly Calendar</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .header {
    position: fixed;
    top: 0;
    left: 300px;
    width: calc(100% - 300px);
    height: 80px; /* Increased height */
    padding: 20px 25px; /* Increased padding */
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #c5cbce; /* Thicker border for impact */
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
}

/* Diagonal Line Overlay for Header */
.header::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px; /* Match sidebar effect */
    opacity: 0.3;
    pointer-events: none; /* Ensures it doesn't block clicks */
    z-index: -1; /* Keeps it behind the header content */
}

body {
    display: flex;
    height: 100vh;
    background: #e1e5e6; /* A solid color */
    color: #3B2F2F; /* Darker warm brown for text */
}

.sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 70px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 42px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 14px 12px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}
.main-content {
    flex: 1;
    padding: 100px 20px 20px; /* Add enough padding to place content below the header */
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    margin-left: 280px; /* Aligns the content to the right of the sidebar */
    overflow-y: auto; /* Ensures content doesn't overflow */
}

.calendar {
    background: none;
    padding: 0;
    border-radius: 0;
    box-shadow: none;
    width: calc(100% - 40px); /* Ensures the calendar width fits nicely within the available space */
}

.calendar-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
    padding: 10px;
}

.days-container {
    display: grid;
    grid-template-columns: repeat(7, 1fr);
    gap: 10px;
    text-align: center;
    margin-top: 2px;
    padding: 15px;
}

.day {
    padding: 15px;
    border-radius: 12px;
    background: white;
    border: 3px solid #2C3E50;
    box-shadow: 4px 4px 10px rgba(44, 62, 80, 0.3), 
                -4px -4px 10px rgba(255, 255, 255, 0.8);
    font-weight: 800;
    color: #2C3E50;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    font-size: 18px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    transition: all 0.3s ease-in-out;
    box-shadow: 3px 3px 8px rgba(1, 1, 1, 1), 
                -3px -3px 6px rgba(255, 255, 255, 0.8);
}

.day:hover {
    background: #2C3E50; /* Keep the original background */
    color: white; /* Keep the original color */
    transform: none; /* Disable transformation on hover */
    box-shadow: 5px 5px 10px rgba(1, 1, 1, 1), 
                -5px -5px 10px rgba(1, 1, 1, 1); /* Keep the original shadow */
}

.day-header {
    margin-top: -10px;
    font-weight: bold;
    padding: 25px;
    border-radius: 8px; /* Slightly rounded for headers */
    border: 3px solid white;
    background: linear-gradient(to bottom,rgb(222, 226, 230), rgb(139, 157, 175), #2C3E50);
    color: white;
    box-shadow: 3px 3px 8px rgba(1, 1, 1, 1), 
                -3px -3px 6px rgba(255, 255, 255, 0.8);
}

.calendar-header button {
    padding: 10px 15px;
    background: linear-gradient(135deg, #a3a4a7, #90a5aa);
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: bold;
    cursor: pointer;
    transition: all 0.3s ease-in-out;
    box-shadow: 2px 2px 8px rgba(0, 0, 0, 0.2);
}

.calendar-header button:hover {
    background: linear-gradient(135deg, #e66b4c, #c7593e);
    transform: scale(1.05);
    box-shadow: 3px 3px 10px rgba(0, 0, 0, 0.3);
}

.calendar-header button:active {
    transform: scale(0.95);
}
.popup {
    display: none;
    position: fixed;
    top: 40%;
    left: 60%;
    transform: translate(-50%, -50%);
    background: #fff;
    border: 10px double #2C3E50;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 10px 10px 10px rgba(1, 1, 1, 1);
    width: 100%;
    max-width: 900px; /* Maximum width for larger screens */
    z-index: 1000;
    animation: fadeIn 0.3s ease-out;
}

.popup h2 {
    margin-bottom: 20px;
    color: #2C3E50;
    font-weight: 600;
    text-align: center;
    font-family: 'Montserrat', sans-serif;
    font-size: 28px;
    font-weight: 800;
    letter-spacing: 8px;
}

.popup table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
}

.popup table, .popup th, .popup td {
    border: 1px solid #344648;
}

.popup th, .popup td {
    padding: 12px;
    text-align: center;
    color: #344648;
    font-size: 16px;
}

.popup th {
    background-color: #2C3E50;
    color: white;
    font-weight: bold;
}

.popup td {
    background-color: #f9f9f9;
}

.popup td:hover {
    background-color: #e3e3e3; /* Slight hover effect */
}

.close {
    cursor: pointer;
    font-size: 28px;
    color: #e74c3c;
    position: absolute;
    top: 15px;
    right: 20px;
    transition: all 0.3s ease;
}

.close:hover {
    transform: scale(1.2);
    color: #c0392b; /* Hover effect on close button */
}

@keyframes fadeIn {
    from {
        opacity: 0;
    }
    to {
        opacity: 1;
    }
}


        .logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}
/* Styling for the buttons */
.nav-btn {
    background-color: #2C3E50;
    color: white;
    border: 2px solidrgb(235, 242, 243);
    padding: 10px 20px;
    font-size: 16px;
    font-weight: bold;
    border-radius: 5px;
    cursor: pointer;
    transition: background-color 0.3s ease, transform 0.3s ease;
}

/* Hover effect for buttons */
.nav-btn:hover {
    background-color: #1A2634;
    transform: scale(1.05);
}

/* Styling for the month-year text */
.month-year {
    font-family: 'Montserrat', sans-serif;
    font-size: 45px;
    font-weight: 800;
    letter-spacing: 10px;
    margin-left: 30px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50; /* Stroke border */
    text-shadow:
        2px 2px 0 #2C3E50,
        4px 4px 0 #1A252F,
        6px 6px 0 #0F151B; /* Stacking shadows for depth */
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
}

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&family=Montserrat:wght@700&family=Bangers&family=Fredoka:wght@700&family=Lobster&display=swap');
.logo-badge span {
    color: #0a0a0a;
}
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>
        <div style="
    margin-top: 80px; 
    font-size: 14px; 
    color: white; 
    border: 2px solid white; 
    padding: 15px 20px; 
    border-radius: 8px; 
    box-shadow: 0 2px 8px rgba(1,1,1,1); 
    width: fit-content;
    font-family: 'Arial', sans-serif; 
    font-weight: bold; 
    text-transform: uppercase; 
    text-align: justify-end;
">
    <div><span style="color: #D9A679;">Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
</div>


        <ul>
        <li><a href="profile.php" style="text-decoration: none; color: white;">IdentiKey</a></li>
            <li><a href="test.php" style="text-decoration: none; color: white;">HubView</a></li>
            <li><a href="service.php" style="text-decoration: none; color: white;">SyncPlanner</a></li>
            <li><a href="StepOut.php" style="text-decoration: none; color: white;">QuickForm</a></li>
            <li><a href="event.php" style="text-decoration: none; color: white;">EventMate</a></li>   
            <li><a href="dashboard.php" style="text-decoration: none; color: white;">DashLytics</a></li>   
            <li><a href="history.php" style="text-decoration: none; color: white;">TrackBack</a></li>  
        </ul> 
    </div>
    <div class="header">

    <button onclick="prevMonth()" class="nav-btn">Previous</button>
    <span id="month-year" class="month-year"></span>
    <button onclick="nextMonth()" class="nav-btn">Next</button>

    </div>
    <div class="popup" id="popup">
        <span class="close" onclick="closePopup()">&times;</span>
        <h2>Events on <span id="popup-date"></span></h2>
        <table>
            <thead>
                <tr>
                    <th>Category</th>
                    <th>Name</th>
                    <th>Time</th>
                    <th>Reason</th>
                </tr>
            </thead>
            <tbody id="event-list"></tbody>
        </table>
    </div>
    <div class="main-content">
        <div class="calendar">
            <div class="days-container">
                <div class="day-header">Sun</div>
                <div class="day-header">Mon</div>
                <div class="day-header">Tue</div>
                <div class="day-header">Wed</div>
                <div class="day-header">Thu</div>
                <div class="day-header">Fri</div>
                <div class="day-header">Sat</div>
            </div>
            <div class="days-container" id="calendar-body"></div>
        </div>
    </div>

    <script>
        let currentDate = new Date();

        function generateCalendar(year, month) {
            const firstDay = new Date(year, month, 1).getDay();
            const daysInMonth = new Date(year, month + 1, 0).getDate();
            document.getElementById("month-year").textContent = new Date(year, month).toLocaleString('default', { month: 'long', year: 'numeric' });

            const calendarBody = document.getElementById("calendar-body");
            calendarBody.innerHTML = "";

            for (let i = 0; i < firstDay; i++) {
                let emptyCell = document.createElement("div");
                emptyCell.classList.add("day", "empty");
                calendarBody.appendChild(emptyCell);
            }

            for (let day = 1; day <= daysInMonth; day++) {
                let cell = document.createElement("div");
                cell.textContent = day;
                cell.classList.add("day");
                cell.addEventListener("click", function () {
                    fetchEvents(month + 1, day);
                });
                calendarBody.appendChild(cell);
            }
        }

        function nextMonth() {
            currentDate.setMonth(currentDate.getMonth() + 1);
            generateCalendar(currentDate.getFullYear(), currentDate.getMonth());
        }

        function prevMonth() {
            currentDate.setMonth(currentDate.getMonth() - 1);
            generateCalendar(currentDate.getFullYear(), currentDate.getMonth());
        }

        function fetchEvents(month, day) {
            let date = `2025-${month.toString().padStart(2, '0')}-${day.toString().padStart(2, '0')}`;
            document.getElementById("popup-date").textContent = date;

            fetch(`get_event.php?date=${date}`)
                .then(response => response.json())
                .then(data => {
                    let eventList = document.getElementById("event-list");
                    eventList.innerHTML = "";

                    if (!data.staff_exit.length && !data.meeting_room.length && !data.company_car.length) {
                        eventList.innerHTML = "<tr><td colspan='2'>No events on this date.</td></tr>";
                    } else {
                        if (data.staff_exit.length) {
                            data.staff_exit.forEach(event => {
                                eventList.innerHTML += `
                                    <tr>
                                        <td>Staff Exit</td>
                                        <td>${event.name}</td>
                                        <td>${event.time}</td>
                                        <td>${event.reason}</td>
                                    </tr>`;
                            });
                        }
                        if (data.meeting_room.length) {
                            data.meeting_room.forEach(event => {
                                eventList.innerHTML += `
                                    <tr>
                                        <td>Meeting Room</td>
                                        <td>${event.name}</td>
                                        <td>${event.time}</td>
                                        <td>${event.reason}</td>
                                    </tr>`;
                            });
                        }
                        if (data.company_car.length) {
                            data.company_car.forEach(event => {
                                eventList.innerHTML += `
                                    <tr>
                                        <td>Company Car</td>
                                        <td>${event.name}</td>
                                        <td>${event.pickup_time}</td>
                                        <td>${event.car_model}</td>
                                    </tr>`;
                            });
                        }
                    }
                    document.getElementById("popup").style.display = "block";
                });
        }

        function closePopup() {
            document.getElementById("popup").style.display = "none";
        }

        generateCalendar(currentDate.getFullYear(), currentDate.getMonth());
    </script>
    
</body>
</html>

