<?php
header('Content-Type: application/json'); // Ensure JSON response
include 'db_connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = isset($_POST["name"]) ? trim($_POST["name"]) : '';
    $date = isset($_POST["date"]) ? trim($_POST["date"]) : '';
    $location = isset($_POST["location"]) ? trim($_POST["location"]) : ''; // New location field

    if (empty($name) || empty($date)) {
        echo json_encode(["status" => "error", "message" => "Name and date are required"]);
        exit;
    }

    // Determine which form was submitted
    if (isset($_POST["reason"]) && isset($_POST["time"]) && isset($_POST["form_type"]) && $_POST["form_type"] === "staff_exit") {
        // Staff Exit Form
        $time = trim($_POST["time"]);
        $reason = trim($_POST["reason"]);

        $sql = "INSERT INTO staff_exit (name, date, time, reason, location) VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssss", $name, $date, $time, $reason, $location);
    } elseif (isset($_POST["reason"]) && isset($_POST["time"]) && isset($_POST["form_type"]) && $_POST["form_type"] === "meeting_room") {
        // Meeting Room Form
        $time = trim($_POST["time"]);
        $reason = trim($_POST["reason"]);

        $sql = "INSERT INTO meeting_room (name, date, time, reason) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $name, $date, $time, $reason);
    } elseif (isset($_POST["car_model"]) && isset($_POST["pickup_time"]) && isset($_POST["form_type"]) && $_POST["form_type"] === "company_car") {
        // Company Car Form
        $car_model = trim($_POST["car_model"]);
        $pickup_time = trim($_POST["pickup_time"]);

        $sql = "INSERT INTO company_car (name, car_model, date, pickup_time) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssss", $name, $car_model, $date, $pickup_time);
    } else {
        echo json_encode(["status" => "error", "message" => "Invalid form submission"]);
        exit;
    }

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Event added successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Database Error: " . $stmt->error]);
    }

    $stmt->close();
}

$conn->close();
?>
