<?php
session_start();
include "db_connection.php";

// Simulate login user ID (replace with your login logic)
$user_id = 1;

// Fetch user details
$query_user = "SELECT * FROM users WHERE id = ?";
$stmt_user = $conn->prepare($query_user);
$stmt_user->bind_param("i", $user_id);
$stmt_user->execute();
$user = $stmt_user->get_result()->fetch_assoc();

// Fetch profile details
$query_profile = "SELECT * FROM profiles WHERE user_id = ?";
$stmt_profile = $conn->prepare($query_profile);
$stmt_profile->bind_param("i", $user_id);
$stmt_profile->execute();
$profile = $stmt_profile->get_result()->fetch_assoc();

// Store in session
$_SESSION['name'] = $user['name'];
$_SESSION['department'] = $profile['department'] ?? '';
$_SESSION['position'] = $profile['position'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Profile</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }

        body {
            display: flex;
            height: 100vh;
            background: #e1e5e6;
            color: #333;
        }

        .sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 70px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 42px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 14px 12px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}

        .logo-badge {
            font-size: 26px;
            font-weight: 900;
            letter-spacing: 2px;
            text-transform: uppercase;
            color: #fdfbf7;
            background: linear-gradient(to right, #6f777e, #e3ebee);
            padding: 12px 24px;
            display: inline-block;
            border-radius: 50px;
            border: 3px solid #F3EDE5;
            box-shadow: 10px 10px 12px rgba(0, 0, 0, 0.8);
            text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5);
            text-align: center;
        }

        .logo-badge span {
            color: #0a0a0a;
        }

        .user-info {
            margin-top: 80px;
            font-size: 14px;
            color: white;
            border: 2px solid white;
            padding: 15px 20px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(1,1,1,1);
            width: fit-content;
            font-weight: bold;
            text-transform: uppercase;
        }

        .user-info span {
            color: #D9A679;
        }

        .header {
            position: fixed;
            top: 0;
            left: 300px;
            width: calc(100% - 300px);
            height: 80px;
            background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
            color: white;
            display: flex;
            align-items: center;
            padding: 0 25px;
            border-bottom: 3px solid #c5cbce;
            box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
        }

        .header::before {
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
            background-size: 40px 40px;
            opacity: 0.3;
            pointer-events: none;
            z-index: -1;
        }

        form {
            margin-left: 300px;
            margin-top: 54px;
            padding: 40px;
            width: calc(100% - 300px);
            background-color: #e1e5e6:
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-size: 16px;
            font-family: 'Poppins', sans-serif; /* Cute and modern font */
            font-weight: bold;
            display: block;
            margin-bottom: 4px;
        }

        .form-group input {
    width: 100%;
    padding: 10px;
    font-size: 14px;
    font-family: 'Poppins', sans-serif; /* Cute and modern font */
    color: #2C3E50; /* Matches your theme */
    border: 3px solid #2C3E50;
    border-radius: 5px;
    box-shadow: 0px 8px 10px rgba(1, 1, 1, 1);
}

/* Submit button with visible border */
.submit-btn {
    padding: 10px;
    background-color: #1A2A35;
    color: white;
    border: 3px solid rgb(240, 243, 247); /* Added visible border */
    box-shadow: 0px 8px 10px rgba(1, 1, 1, 1);
    border-radius: 5px;
    font-size: 16px;
    font-family: 'Poppins', sans-serif; /* Cute and modern font */
    width: 100%;
    cursor: pointer;
}


        .submit-btn:hover {
            background-color: #2C3E50;
        }

        .logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}
@keyframes fadeIn {
    to {
        opacity: 1;
    }
}

@import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@800&display=swap');

.header h1 {
    font-family: 'Montserrat', sans-serif;
    font-size: 48px;
    font-weight: 800;
    letter-spacing: 10px;
    margin-left: 280px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50; /* Stroke border */
    text-shadow:
        2px 2px 0 #2C3E50,
        4px 4px 0 #1A252F,
        6px 6px 0 #0F151B; /* Stacking shadows for depth */
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
}

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&family=Montserrat:wght@700&family=Bangers&family=Fredoka:wght@700&family=Lobster&display=swap');
.logo-badge span {
    color: #0a0a0a;
}
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>

        <div class="user-info">
            <div><span>Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
            <div><span>Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
            <div><span>Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
        </div>

        <ul>
            <li><a href="profile.php">IdentiKey</a></li>
            <li><a href="test.php">HubView</a></li>
            <li><a href="service.php">SyncPlanner</a></li>
            <li><a href="StepOut.html">QuickForm</a></li>
            <li><a href="event.php">EventMate</a></li>   
            <li><a href="dashboard.html">DashLytics</a></li>   
            <li><a href="history.php">TrackBack</a></li>  
        </ul> 
    </div>

    <div class="header">
        <h1>IDENTIKEY</h1>
    </div>

    <form action="update_profile.php" method="post">
        <input type="hidden" name="user_id" value="<?php echo $user['id']; ?>">

        <div class="form-group">
            <label for="full_name">NAME:</label>
            <input type="text" id="full_name" value="<?php echo $user['name']; ?>" readonly>
        </div>

        <div class="form-group">
            <label for="email">EMAIL:</label>
            <input type="email" id="email" value="<?php echo $user['email']; ?>" readonly>
        </div>

        <div class="form-group">
            <label for="phone">PHONE:</label>
            <input type="text" id="phone" name="phone" value="<?php echo $profile['phone'] ?? ''; ?>">
        </div>

        <div class="form-group">
            <label for="department">DEPARTMENT:</label>
            <input type="text" id="department" name="department" value="<?php echo $profile['department'] ?? ''; ?>">
        </div>

        <div class="form-group">
            <label for="position">POSITION:</label>
            <input type="text" id="position" name="position" value="<?php echo $profile['position'] ?? ''; ?>">
        </div>

        <button type="submit" class="submit-btn">COMFIRM IDENTIKEY</button>
    </form>
</body>
</html>
