<?php
session_start();

// Database connection
$host = "localhost";
$username = "root"; // use your DB username
$password = "";     // use your DB password
$database = "event_management"; // your DB name

$conn = new mysqli($host, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get form input
$email = $_POST['email'];
$raw_password = $_POST['password'];

// Query the user based on email
$stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();
    
    // Verify the password
    if (password_verify($raw_password, $user['password'])) {
        // Set session and redirect
        $_SESSION['email'] = $user['email'];
        $_SESSION['fullname'] = $user['fullname']; // optional
        header("Location: test.php");
        exit();
    } else {
        echo "<script>alert('Incorrect password.'); window.location.href='login.html';</script>";
    }
} else {
    echo "<script>alert('Email not registered.'); window.location.href='login.html';</script>";
}

$stmt->close();
$conn->close();
?>
