<?php
session_start();
include "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $request_id = $_POST['request_id'];
    $status = $_POST['status']; // 'Approved by Leader' or 'Rejected by Leader'
    $leader_id = $_SESSION['user_id'];

    $query = "UPDATE leave_requests SET status = ?, leader_approval_by = ?, leader_approval_date = NOW() WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sii", $status, $leader_id, $request_id);

    if ($stmt->execute()) {
        echo "Leave request updated!";
    } else {
        echo "Error: " . $stmt->error;
    }
}
?>

<form method="post">
    <label>Request ID:</label>
    <input type="number" name="request_id" required><br>

    <label>Status:</label>
    <select name="status">
        <option value="Approved by Leader">Approve</option>
        <option value="Rejected by Leader">Reject</option>
    </select><br>

    <button type="submit">Submit</button>
</form>
