<?php 
// Database connection settings
$servername = "localhost"; 
$username = "root"; 
$password = ""; 
$dbname = "event_management"; 

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Query to get staff exit data
$exitQuery = "SELECT time, name, reason FROM staff_exit_data";
$exitResult = $conn->query($exitQuery);

// Query to get booking data
$bookingQuery = "SELECT time, name, room_car, status FROM booking_data"; 
$bookingResult = $conn->query($bookingQuery);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Your head content here -->
</head>
<body>
  <!-- Your side panel content here -->

  <!-- Main Content -->
  <div class="content">
    <div class="box">
      <!-- Staff Exit Table -->
      <div class="table-wrapper" style="flex: 1;">
        <h4 style="font-size: 20px; font-weight: bold; color: white;">Staff Exit</h4>
        <table>
          <thead>
            <tr>
              <th>Time</th>
              <th>Name</th>
              <th>Reason</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            if ($exitResult->num_rows > 0) {
                while ($row = $exitResult->fetch_assoc()) {
                    echo "<tr>
                            <td>" . $row['time'] . "</td>
                            <td>" . $row['name'] . "</td>
                            <td>" . $row['reason'] . "</td>
                          </tr>";
                }
            } else {
                echo "<tr><td colspan='3'>No data available</td></tr>";
            }
            ?>
          </tbody>
        </table>
      </div>

      <!-- Booking Table -->
      <div class="table-wrapper" style="flex: 1;">
        <h4 style="font-size: 20px; font-weight: bold; color: white;">Booking Meeting Room / Car</h4>
        <table>
          <thead>
            <tr>
              <th>Time</th>
              <th>Name</th>
              <th>Room/Car</th>
              <th>Status</th>
            </tr>
          </thead>
          <tbody>
            <?php 
            if ($bookingResult->num_rows > 0) {
                while ($row = $bookingResult->fetch_assoc()) {
                    echo "<tr>
                            <td>" . $row['time'] . "</td>
                            <td>" . $row['name'] . "</td>
                            <td>" . $row['room_car'] . "</td>
                            <td>" . $row['status'] . "</td>
                          </tr>";
                }
            } else {
                echo "<tr><td colspan='4'>No data available</td></tr>";
            }
            ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <!-- Your footer content here -->
  
  <?php 
  // Close the database connection
  $conn->close();
  ?>
</body>
</html>
