<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User History</title>
    <style>
        /* Simple styling for the page */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        .history-section {
            margin-top: 40px;
        }
        .history-item {
            border: 1px solid #ddd;
            padding: 10px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>Your Submission History</h1>

    <!-- History Section -->
    <div class="history-section">
        <label for="userName">Enter Your Name to View History:</label>
        <input type="text" id="userName" placeholder="Enter your name" required>
        <button onclick="fetchHistory()">Fetch History</button>

        <div id="history"></div>
    </div>

    <script>
        // Function to fetch and display the user's history based on the name
        function fetchHistory() {
            const name = document.getElementById("userName").value;
            if (!name) {
                alert("Please enter your name first.");
                return;
            }

            fetch(`fetch_history.php?name=${name}`)
                .then(response => response.json())
                .then(history => {
                    let historyDiv = document.getElementById("history");
                    historyDiv.innerHTML = '';  // Clear any existing content
                    if (history.length === 0) {
                        historyDiv.innerHTML = "<p>No history found for this user.</p>";
                    } else {
                        history.forEach(record => {
                            historyDiv.innerHTML += `
                                <div class="history-item">
                                    <p><strong>Date:</strong> ${record.date}</p>
                                    <p><strong>Reason:</strong> ${record.exit_reason}</p>
                                    <p><strong>Location:</strong> ${record.location}</p>
                                    <p><strong>Time:</strong> ${record.time}</p>
                                </div>
                            `;
                        });
                    }
                })
                .catch(error => {
                    console.error("Error fetching history:", error);
                    alert("Error fetching history.");
                });
        }
    </script>

</body>
</html>
