<?php
include 'db_connection.php';

if (isset($_GET['date'])) {
    $date = $_GET['date'];

    // Allowed tables list
    $allowedTables = ["staff_exit", "meeting_room", "company_car"];

    $staff_exit = fetchEvents($conn, "staff_exit", $date, $allowedTables, true); // apply return_time filter
    $meeting_room = fetchEvents($conn, "meeting_room", $date, $allowedTables);
    $company_car = fetchEvents($conn, "company_car", $date, $allowedTables);

    $conn->close();

    // Return JSON response
    echo json_encode([
        "staff_exit" => $staff_exit,
        "meeting_room" => $meeting_room,
        "company_car" => $company_car
    ]);
} else {
    echo json_encode(["error" => "No date provided"]);
}

function fetchEvents($conn, $table, $date, $allowedTables, $filterReturn = false) {
    if (!in_array($table, $allowedTables)) {
        return [];
    }

    // SQL: if staff_exit, apply extra filter
    if ($table === "staff_exit" && $filterReturn) {
        $stmt = $conn->prepare("SELECT * FROM $table WHERE date = ? AND return_time IS NULL");
    } else {
        $stmt = $conn->prepare("SELECT * FROM $table WHERE date = ?");
    }

    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();

    $events = [];
    while ($row = $result->fetch_assoc()) {
        $events[] = $row;
    }

    $stmt->close();
    return $events;
}
?>
