<?php
include 'db_connection.php';

if (isset($_GET['name'])) {
    $name = $_GET['name'];

    // Fetch the records for the given name
    $stmt = $conn->prepare("SELECT * FROM staff_exit WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $result = $stmt->get_result();

    $history = [];
    while ($row = $result->fetch_assoc()) {
        $history[] = $row;
    }

    // Return the results as JSON
    echo json_encode($history);
} else {
    echo json_encode(["error" => "No name provided"]);
}
?>
