<?php
include 'db_connection.php';

if (isset($_GET['date'])) {
    $date = $_GET['date'];

    $stmt = $conn->prepare("SELECT staff_name, date, time, reason, location FROM staff_exit WHERE date = ?");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();
    $staff_exit = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $stmt = $conn->prepare("SELECT * FROM meeting_room WHERE date = ?");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();
    $meeting_room = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $stmt = $conn->prepare("SELECT * FROM company_car WHERE date = ?");
    $stmt->bind_param("s", $date);
    $stmt->execute();
    $result = $stmt->get_result();
    $company_car = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    $conn->close();

    echo json_encode([
        "staff_exit" => $staff_exit,
        "meeting_room" => $meeting_room,
        "company_car" => $company_car
    ]);
} else {
    echo json_encode(["error" => "No date provided"]);
}
?>
