
<?php
session_start();
include 'db_connection.php';
date_default_timezone_set('Asia/Kuala_Lumpur'); // set your timezone

// Create event + tasks
if (isset($_POST['create_event'])) {
    $name = $_POST['name'];
    $date_from = $_POST['date_from'];
    $date_until = $_POST['date_until'];
    $time = $_POST['time'];
    $details = $_POST['details'];
    $staff_names = $_POST['staff_name'];
    $tasks = $_POST['task'];

    // Insert into events table
    $sql_event = "INSERT INTO events (name, date_from, date_until, time, details)
                  VALUES ('$name', '$date_from', '$date_until', '$time', '$details')";
    if (mysqli_query($conn, $sql_event)) {
        $event_id = mysqli_insert_id($conn);

        // Insert staff & tasks
        foreach ($staff_names as $key => $staff) {
            $task = $tasks[$key];
            $sql_task = "INSERT INTO event_tasks (event_id, staff_name, task)
                         VALUES ('$event_id', '$staff', '$task')";
            mysqli_query($conn, $sql_task);
        }

        echo "Event and tasks saved successfully!";
    } else {
        echo "Error: " . mysqli_error($conn);
    }
}
// Display events
$today = date('Y-m-d');

$upcoming_sql = "SELECT * FROM events WHERE date_until >= '$today' ORDER BY date_from ASC";
$past_sql = "SELECT * FROM events WHERE date_until < '$today' ORDER BY date_from DESC";

$upcoming_result = mysqli_query($conn, $upcoming_sql);
$past_result = mysqli_query($conn, $past_sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EventMate</title>
    <link rel="stylesheet" href="style.css">
    <style>
    /* General Reset */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: Arial, sans-serif;
}

/* Body Styles */
body {
    display: flex;
    height: 100vh;
    background: #e1e5e6; /* Background Color */
    color: #3B2F2F; /* Text Color */
}

/* Header Styles */
.header {
    position: fixed;
    top: 0;
    left: 300px;
    width: calc(100% - 300px);
    height: 80px;
    padding: 20px 25px;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    z-index: 1000;
}

.header h1 {
    font-family: 'Montserrat', sans-serif;
    font-size: 48px;
    font-weight: 800;
    letter-spacing: 10px;
    margin-left: 250px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50;
    text-shadow: 2px 2px 0 #2C3E50, 4px 4px 0 #1A252F, 6px 6px 0 #0F151B;
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
}

@keyframes fadeIn {
    to {
        opacity: 1;
    }
}

/* Sidebar Styles */
.sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 70px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 42px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 14px 12px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}

/* Main Content Styles */
.main-content {
    margin-left: 300px; /* matches the sidebar width */
    padding: 100px 20px 20px; /* 100px accounts for header height and space */
    width: calc(100% - 300px);
    box-sizing: border-box;
}

/* Event Form Styles */


label {
    display: block;
    margin-top: 10px;
    font-weight: bold;
}

input[type="text"],
input[type="date"],
input[type="time"],
textarea {
    width: 100%;
    padding: 10px;
    font-size: 14px;
    font-family: 'Poppins', sans-serif; /* Cute and modern font */
    color: #2C3E50; /* Matches your theme */
    border: 3px solid #2C3E50;
    border-radius: 5px;
    box-shadow: 0px 8px 10px rgba(1, 1, 1, 1);
}

textarea {
    height: 80px;
    resize: vertical;
}

button {
    background-color: #4CAF50;
    color: white;
    padding: 10px 20px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 16px;
}

button:hover {
    background-color: #45a049;
}

hr {
    border: 0;
    height: 1px;
    background: #ddd;
    margin: 40px 0 20px;
}

/* Event Cards Styles */
.event-card {
    background: #fff;
    padding: 15px 20px;
    border-radius: 8px;
    margin-bottom: 20px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
}

.event-card b {
    font-size: 18px;
    color: #2c3e50;
}

ul {
    padding-left: 20px;
    margin-top: 10px;
    color: #555;
}

/* Staff and Task Fields */
input[type="text"][name="staff_name[]"],
input[type="text"][name="task[]"] {
    width: 48%;
    display: inline-block;
    margin-right: 4%;
}

/* Logo Badge Styles */
.logo-badge {
    font-size: 26px;
    font-weight: 900;
    letter-spacing: 2px;
    text-transform: uppercase;
    color: #fdfbf7;
    background: linear-gradient(to right, #6f777e, #e3ebee);
    padding: 12px 24px;
    display: inline-block;
    border-radius: 10px;
    border: 4px solid #F3EDE5;
    box-shadow: 10px 10px 10px rgb(230, 224, 224), -10px -10px 10px rgba(1, 1, 1, 1), 10px -10px 10px rgba(1, 1, 1, 1), -10px 10px 10px rgba(1, 1, 1, 1);
    text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5);
}

.logo-badge span {
    color: #0a0a0a;
}
/* General table styles */
table {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
    font-family: Arial, sans-serif;
}

th, td {
    padding: 12px;
    text-align: left;
    border: 1px solid #ddd;
}

th {
    background-color: #f2f2f2;
    color: #333;
}

td {
    background-color: #fafafa;
}

/* Style for event name (bold and a little larger text) */
td b {
    font-size: 1.1em;
}

/* Style for task list */
ul {
    margin: 0;
    padding-left: 20px;
}

ul li {
    font-size: 0.9em;
}

/* Styling for the table header */
th {
    font-size: 1.1em;
    font-weight: bold;
}

/* Hover effect for table rows */
tr:hover {
    background-color: #f1f1f1;
}

</style>
</head>
<body>
    <div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>
        <div style="margin-top: 80px; font-size: 14px; color: white; border: 2px solid white; padding: 15px 20px; border-radius: 8px; box-shadow: 0 2px 8px rgba(1,1,1,1); width: fit-content; font-family: 'Arial', sans-serif; font-weight: bold; text-transform: uppercase; text-align: justify-end;">
            <div><span style="color: #D9A679;">Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
            <div><span style="color: #D9A679;">Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
            <div><span style="color: #D9A679;">Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
        </div>
        <ul>
            <li><a href="profile.php">IdentiKey</a></li>
            <li><a href="test.php">HubView</a></li>
            <li><a href="service.php">SyncPlanner</a></li>
            <li><a href="StepOut.php">QuickForm</a></li>
            <li><a href="event.php">EventMate</a></li>
            <li><a href="dashboard.php">DashLytics</a></li>
            <li><a href="history.php">TrackBack</a></li>
        </ul> 
    </div>

    <div class="header">
        <h1>EVENTMATE</h1>
    </div>

    <div class="main-content">

        <form method="POST">
            <label>Event Name:</label><br>
            <input type="text" name="name" required><br>

            <label>Date From:</label><br>
            <input type="date" name="date_from" required><br>

            <label>Date Until:</label><br>
            <input type="date" name="date_until" required><br>

            <label>Time:</label><br>
            <input type="time" name="time" required><br>

            <label>Event Details:</label><br>
            <textarea name="details" required></textarea><br><br>

            <h4>Staff & Task:</h4>
            <div id="staffTasks">
                <div>
                    <input type="text" name="staff_name[]" placeholder="Staff Name" required>
                    <input type="text" name="task[]" placeholder="Task" required>
                </div>
            </div>
            <button type="button" onclick="addStaffTask()">+ Add More Staff</button><br><br>

            <button type="submit" name="create_event">Save Event</button>
        </form>

        <hr>

        <h2>Upcoming Events</h2>
<table border="1">
    <tr>
        <th>Event Name</th>
        <th>Event Duration</th>
        <th>Time</th>
        <th>Details</th>
        <th>Staff Tasks</th>
    </tr>
    <?php while($row = mysqli_fetch_assoc($upcoming_result)) {
        $event_id = $row['id'];
        echo "<tr>";
        echo "<td><b>{$row['name']}</b></td>";
        echo "<td>{$row['date_from']} to {$row['date_until']}</td>";
        echo "<td>{$row['time']}</td>";
        echo "<td>{$row['details']}</td>";
        echo "<td><ul>";

        // Fetch tasks
        $task_query = mysqli_query($conn, "SELECT * FROM event_tasks WHERE event_id = '$event_id'");
        while($task = mysqli_fetch_assoc($task_query)) {
            echo "<li>{$task['staff_name']}: {$task['task']}</li>";
        }

        echo "</ul></td>";
        echo "</tr>";
    }
    ?>
</table>

<h2>Past Events</h2>
<table border="1">
    <tr>
    <th>Event Name</th>
        <th>Event Duration</th>
        <th>Time</th>
        <th>Details</th>
        <th>Staff Tasks</th>
    </tr>
    <?php while($row = mysqli_fetch_assoc($past_result)) {
        $event_id = $row['id'];
        echo "<tr>";
        echo "<td><b>{$row['name']}</b></td>";
        echo "<td>{$row['date_from']} to {$row['date_until']}</td>";
        echo "<td>{$row['time']}</td>";
        echo "<td>{$row['details']}</td>";
        echo "<td><ul>";

        // Fetch tasks
        $task_query = mysqli_query($conn, "SELECT * FROM event_tasks WHERE event_id = '$event_id'");
        while($task = mysqli_fetch_assoc($task_query)) {
            echo "<li>{$task['staff_name']}: {$task['task']}</li>";
        }

        echo "</ul></td>";
        echo "</tr>";
    }
    ?>
</table>


    <script>
    function addStaffTask() {
        let container = document.getElementById('staffTasks');
        let div = document.createElement('div');
        div.innerHTML = `
            <input type="text" name="staff_name[]" placeholder="Staff Name" required>
            <input type="text" name="task[]" placeholder="Task" required>
        `;
        container.appendChild(div);
    }
    </script>
</body>
</html>