<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Staff Exit Report</title>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .header {
    position: fixed;
    top: 0;
    left: 300px;
    width: calc(100% - 300px);
    height: 80px; /* Increased height */
    padding: 20px 25px; /* Increased padding */
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #c5cbce; /* Thicker border for impact */
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
}

/* Diagonal Line Overlay for Header */
.header::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px; /* Match sidebar effect */
    opacity: 0.3;
    pointer-events: none; /* Ensures it doesn't block clicks */
    z-index: -1; /* Keeps it behind the header content */
}

body {
    display: flex;
    height: 100vh;
    background: #e1e5e6; /* A solid color */
    color: #3B2F2F; /* Darker warm brown for text */
}

.sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 74px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 40px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 9px 8px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}

    .content {
      margin-left: 290px;
      margin-top: 90px;
      padding: 20px;
      width: calc(100% - 290px);
    }

    .filter-bar {
      display: flex;
      gap: 15px;
      align-items: center;
      margin-bottom: 20px;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-bottom: 10px;
      background-color: white;
    }

    table, th, td {
      border: 1px solid #ccc;
    }

    th, td {
      padding: 10px;
      text-align: left;
    }

    .table-container {
      max-height: 300px;
      overflow-y: auto;
    }

    #seeMoreBtn {
      background-color: #2C3E50;
      color: white;
      padding: 10px 15px;
      border: none;
      cursor: pointer;
      border-radius: 5px;
      display: block;
      margin: 0 auto 20px auto;
    }

    .chart-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(420px, 1fr));
      gap: 30px;
    }

    canvas {
      background-color: white;
      padding: 10px;
      border-radius: 10px;
    }

    h2, h3 {
      text-align: center;
      margin: 15px 0;
    }

    .logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&family=Montserrat:wght@700&family=Bangers&family=Fredoka:wght@700&family=Lobster&display=swap');
.logo-badge span {
    color: #0a0a0a;
}
h1 {
    font-family: 'Montserrat', sans-serif;
    font-size: 48px;
    font-weight: 800;
    letter-spacing: 10px;
    margin-left: 280px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50;
    text-shadow:
        2px 2px 0 #2C3E50,
        4px 4px 0 #1A252F,
        6px 6px 0 #0F151B;
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
    background-color: transparent; /* optional: to keep background clear */
}

/* Animation keyframes */
@keyframes fadeIn {
    to {
        opacity: 1;
    }
}

  </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>
        <div style="
    margin-top: 80px; 
    font-size: 14px; 
    color: white; 
    border: 2px solid white; 
    padding: 15px 20px; 
    border-radius: 8px; 
    box-shadow: 0 2px 8px rgba(1,1,1,1); 
    width: fit-content;
    font-family: 'Arial', sans-serif; 
    font-weight: bold; 
    text-transform: uppercase; 
    text-align: justify-end;
">
    <div><span style="color: #D9A679;">Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
</div>


        <ul>
        <li><a href="profile.php" style="text-decoration: none; color: white;">IdentiKey</a></li>
            <li><a href="test.php" style="text-decoration: none; color: white;">HubView</a></li>
            <li><a href="service.php" style="text-decoration: none; color: white;">SyncPlanner</a></li>
            <li><a href="StepOut.html" style="text-decoration: none; color: white;">QuickForm</a></li>
            <li><a href="event.php" style="text-decoration: none; color: white;">EventMate</a></li>   
            <li><a href="dashboard.html" style="text-decoration: none; color: white;">DashLytics</a></li>   
            <li><a href="history.php" style="text-decoration: none; color: white;">TrackBack</a></li>  
        </ul> 
    </div>

<div class="header">
  <h1>DASHLYTIC</h1>
</div>

<div class="content">
    <h2>Monthly Staff Exit Report</h2>
  
    <div class="filter-bar">
      <label>Select Month:</label>
      <input type="month" id="monthPicker">
      <button onclick="fetchStaffExitEvents()">Load Data</button>
    </div>
  
    <h3>Exit Records</h3>
    <div class="table-container" id="table-container">
      <table>
        <thead>
          <tr>
            <th>Time</th>
            <th>Name</th>
            <th>Reason</th>
            <th>Location</th>
          </tr>
        </thead>
        <tbody id="staff-exit-list">
          <tr><td colspan="4">Loading...</td></tr>
        </tbody>
      </table>
    </div>
    <button id="seeMoreBtn" onclick="toggleTable()">See More</button>
  
    <div class="chart-grid">
      <div>
        <h3>Most Frequent Staff Exits</h3>
        <canvas id="exitChart"></canvas>
      </div>
      <div>
        <h3>Exit Trend Over the Month</h3>
        <canvas id="exitTrendChart"></canvas>
      </div>
      <div>
        <h3>Exit Reasons Breakdown</h3>
        <canvas id="exitReasonChart"></canvas>
      </div>
      <div>
        <h3>Staff Exit Reasons</h3>
        <canvas id="staffReasonChart"></canvas>
      </div>
      <div style="grid-column: span 2;">
        <h3>Staff Exit Patterns</h3>
        <canvas id="staffExitRadarChart"></canvas>
      </div>
    </div>
  </div>
  
  <script>
    function toggleTable() {
      const container = document.getElementById("table-container");
      if (container.style.maxHeight === "none") {
        container.style.maxHeight = "300px";
        document.getElementById("seeMoreBtn").innerText = "See More";
      } else {
        container.style.maxHeight = "none";
        document.getElementById("seeMoreBtn").innerText = "See Less";
      }
    }
  
    document.getElementById("monthPicker").value = new Date().toISOString().slice(0, 7);
    fetchStaffExitEvents();
  
    function fetchStaffExitEvents() {
      let selectedMonth = document.getElementById("monthPicker").value || new Date().toISOString().slice(0, 7);
  
      fetch(`staff_exit_report.php?month=${selectedMonth}`)
        .then(response => response.json())
        .then(data => {
          let exitList = document.getElementById("staff-exit-list");
          let staffCounts = {};
          let dailyExitCounts = {};
          let reasonCounts = {};
          let staffReasonData = {};
          let staffPatternData = {};
  
          exitList.innerHTML = data.staff_exit.length 
            ? data.staff_exit.map(event => {
                staffCounts[event.name] = (staffCounts[event.name] || 0) + 1;
  
                let day = event.time.split(" ")[0];
                dailyExitCounts[day] = (dailyExitCounts[day] || 0) + 1;
  
                reasonCounts[event.reason] = (reasonCounts[event.reason] || 0) + 1;
  
                if (!staffReasonData[event.name]) staffReasonData[event.name] = {};
                staffReasonData[event.name][event.reason] = (staffReasonData[event.name][event.reason] || 0) + 1;
  
                if (!staffPatternData[event.name]) staffPatternData[event.name] = {};
                staffPatternData[event.name][event.reason] = (staffPatternData[event.name][event.reason] || 0) + 1;
  
                return `
                  <tr>
                    <td>${event.time}</td>
                    <td>${event.name}</td>
                    <td>${event.reason}</td>
                    <td>${event.location}</td>
                  </tr>`;
              }).join('') 
            : "<tr><td colspan='4'>No staff exits recorded this month.</td></tr>";
  
          drawExitChart(Object.keys(staffCounts), Object.values(staffCounts));
          drawExitTrendChart(Object.keys(dailyExitCounts), Object.values(dailyExitCounts));
          drawExitReasonChart(Object.keys(reasonCounts), Object.values(reasonCounts));
  
          let staffNames = Object.keys(staffReasonData);
          let reasonLabels = [...new Set(data.staff_exit.map(event => event.reason))];
  
          let datasets = reasonLabels.map(reason => ({
            label: reason,
            data: staffNames.map(name => staffReasonData[name][reason] || 0),
            backgroundColor: `rgba(${Math.random()*255}, ${Math.random()*255}, ${Math.random()*255}, 0.6)`
          }));
  
          drawStaffReasonChart(staffNames, datasets);
  
          let radarDatasets = staffNames.map(name => ({
            label: name,
            data: reasonLabels.map(reason => staffPatternData[name][reason] || 0),
            fill: true,
            borderColor: `rgba(${Math.random()*255}, ${Math.random()*255}, ${Math.random()*255}, 0.6)`
          }));
  
          drawStaffExitRadarChart(reasonLabels, radarDatasets);
        });
    }
  
    function drawExitChart(labels, values) {
      let ctx = document.getElementById("exitChart").getContext("2d");
      if (window.exitChartInstance) window.exitChartInstance.destroy();
      window.exitChartInstance = new Chart(ctx, {
        type: "bar",
        data: { labels, datasets: [{ label: "Most Frequent Staff Exits", data: values, backgroundColor: "rgba(75, 192, 192, 0.6)", borderColor: "rgba(75, 192, 192, 1)", borderWidth: 1 }] },
        options: { responsive: true }
      });
    }
  
    function drawExitTrendChart(labels, values) {
      let ctx = document.getElementById("exitTrendChart").getContext("2d");
      if (window.exitTrendChartInstance) window.exitTrendChartInstance.destroy();
      window.exitTrendChartInstance = new Chart(ctx, {
        type: "line",
        data: { labels, datasets: [{ label: "Daily Exit Trend", data: values, backgroundColor: "rgba(255, 99, 132, 0.2)", borderColor: "rgba(255, 99, 132, 1)", borderWidth: 2, fill: true }] },
        options: { responsive: true }
      });
    }
  
    function drawExitReasonChart(labels, values) {
      let ctx = document.getElementById("exitReasonChart").getContext("2d");
      if (window.exitReasonChartInstance) window.exitReasonChartInstance.destroy();
      window.exitReasonChartInstance = new Chart(ctx, {
        type: "doughnut",
        data: { labels, datasets: [{ label: "Exit Reasons", data: values, backgroundColor: ["#FF6384", "#36A2EB", "#FFCE56", "#4BC0C0"] }] },
        options: { responsive: true }
      });
    }
  
    function drawStaffReasonChart(labels, datasets) {
      let ctx = document.getElementById("staffReasonChart").getContext("2d");
      if (window.staffReasonChartInstance) window.staffReasonChartInstance.destroy();
      window.staffReasonChartInstance = new Chart(ctx, {
        type: "bar",
        data: {
          labels: labels,
          datasets: datasets
        },
        options: {
          responsive: true,
          scales: {
            x: { stacked: true },
            y: { stacked: true }
          }
        }
      });
    }
  
    function drawStaffExitRadarChart(labels, datasets) {
      let ctx = document.getElementById("staffExitRadarChart").getContext("2d");
      if (window.staffExitRadarChartInstance) window.staffExitRadarChartInstance.destroy();
      window.staffExitRadarChartInstance = new Chart(ctx, {
        type: "radar",
        data: {
          labels: labels,
          datasets: datasets
        },
        options: {
          responsive: true,
          elements: {
            line: {
              borderWidth: 2
            }
          }
        }
      });
    }
  </script>
  
  </body>
  </html>