<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the submitted form data
    $eventName = $_POST['event_name'];
    $eventMotive = $_POST['event_motive'];
    $staffCount = $_POST['staff_count'];
    $tasks = $_POST['task']; // Array of tasks
    $names = $_POST['task_names']; // Array of task assignees

    // Email setup
    $to = "recipient@example.com"; // Replace with the recipient's email address
    $subject = "New Event Created: " . $eventName;
    $message = "Event Name: " . $eventName . "\n";
    $message .= "Motivation: " . $eventMotive . "\n";
    $message .= "Number of Staff Involved: " . $staffCount . "\n";
    $message .= "Tasks Assigned:\n";
    
    foreach ($tasks as $index => $task) {
        $message .= "Task: " . $task . " | Assignee: " . $names[$index] . "\n";
    }
    
    // Send the email
    mail($to, $subject, $message);

    echo "Event and tasks have been created, and an email notification has been sent.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Event</title>
    <style>
        /* Add your styles here */
    </style>
</head>
<body>

    <div class="container">
        <h2>Create New Event</h2>
        <form action="create_event.php" method="POST">
            <!-- Event Information Section -->
            <label for="event_name">Event Name:</label>
            <input type="text" id="event_name" name="event_name" required><br><br>

            <label for="event_motive">Event Motive:</label>
            <input type="text" id="event_motive" name="event_motive" required><br><br>

            <label for="staff_count">Number of Staff Involved:</label>
            <input type="number" id="staff_count" name="staff_count" min="1" required><br><br>

            <!-- Task Table Section -->
            <h3>Task Assignment</h3>
            <table id="taskTable">
                <tr>
                    <th>Task</th>
                    <th>Assign to</th>
                </tr>
                <tr>
                    <td><input type="text" name="task[]"></td>
                    <td><input type="text" name="task_names[]"></td>
                </tr>
            </table>
            <button type="button" id="addTaskButton">Add Task</button><br><br>

            <input type="submit" value="Create Event">
        </form>
    </div>

    <script>
        // JavaScript to handle adding new task rows
        document.getElementById('addTaskButton').addEventListener('click', function() {
            var table = document.getElementById('taskTable');
            var newRow = table.insertRow();
            var cell1 = newRow.insertCell(0);
            var cell2 = newRow.insertCell(1);
            cell1.innerHTML = '<input type="text" name="task[]">';
            cell2.innerHTML = '<input type="text" name="task_names[]">';
        });
    </script>

</body>
</html>
