<?php
session_start();
include "db_connection.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $request_id = $_POST['request_id'];
    $status = $_POST['status']; // 'Approved' or 'Rejected'
    $boss_id = $_SESSION['user_id'];

    $query = "UPDATE leave_requests SET status = ?, boss_approval_by = ?, boss_approval_date = NOW() WHERE id = ? AND status = 'Approved by Leader'";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("sii", $status, $boss_id, $request_id);

    if ($stmt->execute()) {
        echo "Leave request updated!";
    } else {
        echo "Error: " . $stmt->error;
    }
}
?>

<form method="post">
    <label>Request ID:</label>
    <input type="number" name="request_id" required><br>

    <label>Status:</label>
    <select name="status">
        <option value="Approved">Approve</option>
        <option value="Rejected">Reject</option>
    </select><br>

    <button type="submit">Submit</button>
</form>
