<?php
session_start();
include "db_connection.php";

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit();
}

$user_id = $_SESSION['user_id'];
$message = "";

// Handle leave request submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $leave_date_start = $_POST['leave_date_start'];
    $leave_date_end = $_POST['leave_date_end'];
    $reason = $_POST['reason'];

    $query = "INSERT INTO leave_requests (user_id, leave_date_start, leave_date_end, reason) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("isss", $user_id, $leave_date_start, $leave_date_end, $reason);

    if ($stmt->execute()) {
        $message = "Leave request submitted!";
    } else {
        $message = "Error: " . $stmt->error;
    }
}

// Fetch leave history
$query = "SELECT * FROM leave_requests WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Leave Application</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

        .message {
            padding: 10px;
            margin-bottom: 20px;
            background-color: #e0ffe0;
            border: 1px solid #00aa00;
            color: #007700;
        }

        form {
            margin-bottom: 30px;
        }

        input[type="date"], textarea {
            width: 100%;
            padding: 8px;
            margin-top: 4px;
            margin-bottom: 10px;
        }

        button {
            padding: 10px 15px;
            background-color: #2C3E50;
            color: white;
            border: none;
            cursor: pointer;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        table, th, td {
            border: 1px solid black;
        }

        th, td {
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #2C3E50;
            color: white;
        }
    </style>
</head>
<body>

    <h2>Apply for Leave</h2>
    
    <?php if ($message): ?>
        <div class="message"><?= $message ?></div>
    <?php endif; ?>

    <form method="post">
        <label>Start Date:</label>
        <input type="date" name="leave_date_start" required><br>

        <label>End Date:</label>
        <input type="date" name="leave_date_end" required><br>

        <label>Reason:</label>
        <textarea name="reason" required></textarea><br>

        <button type="submit">Apply for Leave</button>
    </form>

    <h2>Your Leave History</h2>
    <table>
        <tr>
            <th>Reason</th>
            <th>Start Date</th>
            <th>End Date</th>
            <th>Status</th>
            <th>Download Letter</th>
        </tr>
        <?php while ($row = $result->fetch_assoc()) { ?>
        <tr>
            <td><?= htmlspecialchars($row['reason']) ?></td>
            <td><?= htmlspecialchars($row['leave_date_start']) ?></td>
            <td><?= htmlspecialchars($row['leave_date_end']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><a href="download_leave_letter.php?id=<?= $row['id'] ?>">Download Letter</a></td>
        </tr>
        <?php } ?>
    </table>

</body>
</html>
