<?php
session_start();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Service - Yearly Calendar</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@800&display=swap" rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
        }

        .header {
    position: fixed;
    top: 0;
    left: 300px;
    width: calc(100% - 300px);
    height: 80px; /* Increased height */
    padding: 20px 25px; /* Increased padding */
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 3px solid #c5cbce; /* Thicker border for impact */
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
}

/* Diagonal Line Overlay for Header */
.header::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px; /* Match sidebar effect */
    opacity: 0.3;
    pointer-events: none; /* Ensures it doesn't block clicks */
    z-index: -1; /* Keeps it behind the header content */
}

body {
    display: flex;
    height: 100vh;
    background: #e1e5e6; /* A solid color */
    color: #3B2F2F; /* Darker warm brown for text */
}

.sidebar {
    width: 300px;
    height: 100vh;
    background: linear-gradient(to bottom, #2C3E50, #1A2A35, #0F1B25);
    padding: 20px 15px;
    color: white;
    border-right: 3px solid #c5cbce;
    box-shadow: 6px 6px 6px rgba(1, 1, 1, 1);
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
}

.sidebar h2 {
    text-align: center;
    margin-bottom: 10px;
    font-size: 20px;
    font-weight: bold;
}

.sidebar a {
    color: white;
    text-decoration: none;
    font-weight: bold;
    font-size: 14px;
    transition: color 0.3s ease-in-out;
    margin-left: 70px;
}

.sidebar a:hover {
    color: #E8C7A2;
}

.sidebar ul {
    margin-top: 42px;
    list-style: none;
    padding: 0;
    border-top: 5px solid white;
}

.sidebar ul li {
    padding: 14px 12px;
    cursor: pointer;
    transition: 0.3s;
    border-bottom: 1px solid white;
    font-size: 14px;
    font-weight: bold;
}

.sidebar ul li:last-child {
    border-bottom: none;
}

.sidebar ul li:hover {
    background: rgba(247, 185, 161, 0.5);
    border-radius: 5px;
}

.sidebar::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 10%, transparent 10%, transparent 50%, rgba(255, 255, 255, 0.1) 50%);
    background-size: 40px 40px;
    opacity: 0.3;
    pointer-events: none;
}
        .container {
    position: absolute;
    top: 60px; /* Push it below the header */
    left: 260px; /* Push it right of the sidebar */
    width: calc(100% - 260px); /* Take remaining width */
    height: calc(100vh - 60px); /* Take full height minus header */
    padding: 20px;
    background: transparent;
    border-radius: 10px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    text-align: center;
    overflow-y: auto; /* Allows scrolling if content overflows */
}
.form-tabs {
    display: flex;
    justify-content: center;
    gap: 10px;
    margin-bottom: 20px;
}

.form-tabs button {
    background-color: #f4f4f4; /* Light gray background */
    color: #333; /* Dark text */
    border: none;
    padding: 12px 20px;
    font-size: 16px;
    font-weight: bold;
    border-radius: 8px; /* Rounded corners */
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.1);
}

.form-tabs button:hover {
    background-color: #ddd; /* Slightly darker on hover */
    transform: scale(1.05); /* Slightly bigger effect */
}

.form-tabs button.active {
    background-color: #007bff; /* Primary blue */
    color: white;
    box-shadow: 2px 2px 8px rgba(0, 123, 255, 0.4);
    transform: translateY(-2px); /* Slight lift effect */
}

        .form-section {
            display: none;
        }
        .form-section.active {
            display: block;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        form label {
            font-weight: bold;
        }
        form input, form textarea {
    margin-left: 100px;
    padding: 14px;
    width: 800px; /* Adjust based on content */
    border: 2px solid #74471f; /* Elegant warm accent */
    border-radius: 8px;
    background: #F3EDE5; /* Soft nude tone */
    color: #3B2F2F; /* Dark brown text */
    font-size: 14px;
    outline: none;
    transition: 0.3s ease-in-out;
    box-shadow: inset 0px 2px 5px rgb(38, 46, 68);
}

form input:focus, form textarea:focus {
    border-color: #8C6A5D; /* Deep brown highlight */
    background: #FFF8F2; /* Slightly lighter when focused */
    box-shadow: 0px 0px 8px rgba(217, 166, 121, 0.8);
}

form textarea {
    resize: none; /* Prevent resizing */
    min-height: 100px; /* Set a comfortable height */
}

        form button {
            margin-left: 430px;
            margin-top: 15px;
            padding: 10px;
            width: 20%;
            background: #f58c6b;
            border: none;
            color: white;
            font-weight: bold;
            cursor: pointer;
            border-radius: 5px;
            transition: 0.3s;
        }
        form button:hover {
            background: #e67359;
        }
        
        logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&family=Montserrat:wght@700&family=Bangers&family=Fredoka:wght@700&family=Lobster&display=swap');
.logo-badge span {
    color: #0a0a0a;
}

.menu-container {
            position: relative;
        }
        #formSelector {
    margin-left: 920px;
    padding: 2px 2px;
    font-size: 14px;
    font-weight: bolder;
    border: 2px solid #5E4B56;
    box-shadow: 0px 0px 4px rgba(1, 1, 1, 1);
    border-radius: 4px;
    background: white;
    cursor: pointer;
    color: #5E4B56;
    width: auto;
    height: 40px;
    transition: border-color 0.2s ease-in-out, background 0.2s ease-in-out;
}

#formSelector:focus {
    outline: none;
    border-color: #3d2f37;
    box-shadow: 0px 0px 4px rgba(1, 1, 1, 1);
}

#formSelector:hover {
    background: #f9f9f9;
}

#formSelector option {
    font-size: 12px;
    color: #5E4B56;
}
        
        .menu-content {
            display: none;
            position: absolute;
            top: 40px;
            right: 40px;
            background: white;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            z-index: 1000;
        }
        
        .menu-content button {
            display: block;
            width: 100%;
            padding: 10px;
            border: none;
            background: none;
            text-align: left;
            font-size: 14px;
            cursor: pointer;
            transition: 0.3s;
        }
        
        .menu-content button:hover {
            background: #f58c6b;
            color: white;
        }
        /* Container for Date, Time, Name, and Reason */
        .logo-badge {
            font-size: 26px; /* Slightly bigger */
font-weight: 900; /* Maximum boldness */
letter-spacing: 2px; /* Adds emphasis */
text-transform: uppercase;
color: #fdfbf7;
background: linear-gradient(to right, #6f777e, #e3ebee);
padding: 12px 24px; /* More padding for emphasis */
display: inline-block;
border-radius: 10px;
border: 4px solid #F3EDE5; /* Thicker border */
box-shadow: 10px 10px 10px rgb(230, 224, 224), 
                -10px -10px 10px rgba(1, 1, 1, 1),
                10px -10px 10px rgba(1, 1, 1, 1), 
                -10px 10px 10px rgba(1, 1, 1, 1); /* Shadow all around */
text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5); /* Adds contrast */

}
/* Styling for the heading */
@keyframes fadeIn {
  to {
    opacity: 1;
  }
}

.header h2 {
    font-family: 'Montserrat', sans-serif;
    font-size: 48px;
    font-weight: 800;
    letter-spacing: 10px;
    margin-left: 280px;
    color: #ffffff;
    -webkit-text-stroke: 1px #2C3E50;
    text-shadow:
        2px 2px 0 #2C3E50,
        4px 4px 0 #1A252F,
        6px 6px 0 #0F151B;
    transform: perspective(400px) rotateX(10deg);
    animation: fadeIn 1s forwards;
    opacity: 0;
    padding: 20px;
    width: fit-content;
    border-radius: 10px;
}

    </style>
</head>
<body>
<div class="sidebar">
        <div class="logo-badge">TRACK<span>SYNC</span></div>
        <div style="
    margin-top: 80px; 
    font-size: 14px; 
    color: white; 
    border: 2px solid white; 
    padding: 15px 20px; 
    border-radius: 8px; 
    box-shadow: 0 2px 8px rgba(1,1,1,1); 
    width: fit-content;
    font-family: 'Arial', sans-serif; 
    font-weight: bold; 
    text-transform: uppercase; 
    text-align: justify-end;
">
    <div><span style="color: #D9A679;">Name:</span> <?php echo strtoupper($_SESSION['name'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Department:</span> <?php echo strtoupper($_SESSION['department'] ?? '-'); ?></div>
    <div><span style="color: #D9A679;">Position:</span> <?php echo strtoupper($_SESSION['position'] ?? '-'); ?></div>
</div>


        <ul>
        <li><a href="profile.php" style="text-decoration: none; color: white;">IdentiKey</a></li>
            <li><a href="test.php" style="text-decoration: none; color: white;">HubView</a></li>
            <li><a href="service.php" style="text-decoration: none; color: white;">SyncPlanner</a></li>
            <li><a href="StepOut.php" style="text-decoration: none; color: white;">QuickForm</a></li>
            <li><a href="event.php" style="text-decoration: none; color: white;">EventMate</a></li>   
            <li><a href="dashboard.php" style="text-decoration: none; color: white;">DashLytics</a></li>   
            <li><a href="history.php" style="text-decoration: none; color: white;">TrackBack</a></li>  
        </ul> 
    </div>

    <div class="header">
        <h2>QUICKFORM</h2>
    </div>

    <div class="container">
        <div class="form-tabs">
            <select id="formSelector" onchange="showForm(this.value)">
                <option value="0">StepOut</option>
                <option value="1">MeetRoom</option>
                <option value="2">CarDrive</option>
            </select>
        </div>
    
        <div class="form-section active" id="form0">
            <h2 style="letter-spacing: 50px; margin: -45px 0 5px 20px; font-size: 45px; font-weight: 800; text-transform: uppercase;">
                StepOut
            </h2>            
            <form class="submission-form" action="save_event.php" method="post">
                <input type="hidden" name="form_type" value="staff_exit">
                
                <label>Name:</label>
                <input type="text" name="name" required> 
            
                <label>Time:</label>
                <input type="time" name="time" required>
            
                <label>Reason:</label>
                <input type="text" name="reason" required>
            
                <label>Date:</label>
                <input type="date" name="date" required>

                <label for="location">Current Location:</label>
                <input type="text" id="location" name="location" readonly placeholder="Fetching location...">
                <button type="button" onclick="getLocation()">Get Location</button>
            
                <button type="submit">
                    </i> ConfirmStepOut  <i class="fas fa-running"></i>
                </button>  
            </form>            
        </div>
    
        <div class="form-section" id="form1">
            <h2 style="letter-spacing: 50px; margin: -45px 0 5px 20px; font-size: 45px; font-weight: 800; text-transform: uppercase;">
                MeetRoom
            </h2>
            <form class="submission-form" action="save_event.php" method="post">
                <input type="hidden" name="form_type" value="meeting_room"> <!-- Added hidden field -->
        
                <label>Name:</label>
                <input type="text" name="name" required>
        
                <label>Time:</label>
                <input type="time" name="time" required>
        
                <label>Reason:</label>
                <input type="text" name="reason" required>
        
                <label>Date:</label>
                <input type="date" name="date" required>
        
                <button type="submit">
                    </i> FixTheMeet  <i class="fas fa-users"></i>
                </button>
            </form>
        </div>
        
        
        <div class="form-section" id="form2">
            <h2 style="letter-spacing: 50px; margin: -45px 0 5px 20px; font-size: 45px; font-weight: 800; text-transform: uppercase;">
                CarDrive
            </h2>
        <form class="submission-form" action="save_event.php" method="post">
            <input type="hidden" name="form_type" value="company_car">
            
            <label>Name:</label>
            <input type="text" name="name" required>
        
            <label>Car Model:</label>
            <input type="text" name="car_model" required>
        
            <label>Pickup Time:</label>
            <input type="time" name="pickup_time" required>
        
            <label>Date:</label>
            <input type="date" name="date" required>
        
            <button type="submit">
                </i> BookTheCar   <i class="fas fa-car"></i>
            </button>            
        </form>                
    </div>
    
    <script>
        function showForm(index) {
            let forms = document.querySelectorAll('.form-section');
    
            // Hide all forms
            forms.forEach((form, i) => {
                form.style.display = i == index ? 'block' : 'none';
            });
        }
    
        // Show the first form by default
        document.addEventListener("DOMContentLoaded", function () {
            showForm(0);
        });

// Ensure only the first form is visible by default
document.addEventListener("DOMContentLoaded", function() {
    showForm(0);
});
        document.querySelectorAll(".submission-form").forEach(form => {
            form.addEventListener("submit", function (e) {
                e.preventDefault(); 

                let formData = new FormData(this);

                fetch("save_event.php", {
                    method: "POST",
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === "success") {
                        alert("Submission Successful");
                        window.location.href = "test.html"; 
                    } else {
                        alert("Submission Failed: " + data.message);
                    }
                })
                .catch(error => {
                    console.error("Error submitting form:", error);
                    alert("Submission Error! Check Console.");
                });
            });
        });
    </script>  

<script>
    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(showPosition, showError);
        } else {
            document.getElementById("location").value = "Geolocation is not supported by this browser.";
        }
    }
    
    function showPosition(position) {
        let lat = position.coords.latitude;
        let lon = position.coords.longitude;
        
        // Convert to an address using OpenStreetMap Nominatim API
        fetch(`https://nominatim.openstreetmap.org/reverse?format=json&lat=${lat}&lon=${lon}`)
        .then(response => response.json())
        .then(data => {
            document.getElementById("location").value = data.display_name;
        })
        .catch(error => {
            document.getElementById("location").value = `Lat: ${lat}, Lon: ${lon}`;
        });
    }
    
    function showError(error) {
        switch (error.code) {
            case error.PERMISSION_DENIED:
                document.getElementById("location").value = "User denied location access.";
                break;
            case error.POSITION_UNAVAILABLE:
                document.getElementById("location").value = "Location unavailable.";
                break;
            case error.TIMEOUT:
                document.getElementById("location").value = "Location request timed out.";
                break;
            default:
                document.getElementById("location").value = "An unknown error occurred.";
        }
    }
    </script>   

</body>
</html>